class Ex5_3
parameter Real p(unit="N/m^2")=7.58*10^4;/*pressure at a point on the wing of the airplane*/

parameter Real p_infinite(unit="N/m^2")=7.95*10^4;/*atmospheric pressure at 2000 m*/
parameter Real rho_infinite(unit="kg/m^3")=1.0066;/*atmospheric density at 2000 m*/
parameter Real V_infinite(unit="m/s")=70;/*velocity of the airplane*/

Real q_infinite(unit="N/m^2");/*dynamics pressure*/
Real C_p;/*pressure coefficient in secified point of the wing*/
equation
q_infinite=(1/2)*rho_infinite*V_infinite^2;
C_p=(p-p_infinite)/q_infinite;
end Ex5_3;
