class Ex6_13
/*Weight conversion 1 gal=6.67 lb */
/*specific fuel conversion 1 lb fuel/lb thrust.h= 1/3600 s^(-1)*/

parameter Real rho_infinite(unit="slug/ft^3")=0.001184;/*atmospheric density at 22000 ft*/

parameter Real c_1(unit="lb fuel/(lb thrust.h)")=0.6;/*specific fuel consumption in lb fuel/(lb thrust.h*/
Real c_t(unit="s^(-1)");/*specific fuel consumption in per second*/

parameter Real C_L_b_C_D_max=16.9;/*maximum C_L by C_D ratio*/
parameter Real C_L_b_C_D_max1=23.4;/*maximum C_L^(1/2) by C_D ratio*/

parameter Real S(unit="ft^2")=318;/*wing area*/

parameter Real W_0(unit="lb")=19815;/*gross weight of the CP-1*/
parameter Real W_f_g(unit="gal")=1119;/*weight of kerosene in galon*/
Real W_f(unit="lb");/*weight of kerosene in lb*/
Real W_1(unit="lb");/*empty weight of CJ-1*/

Real R(unit="ft");/*maximum range*/
Real E(unit="s");/*maximum endurance*/

equation
c_t=c_1/3600;

W_f=W_f_g*6.67;
W_1=W_0-W_f;

R=2*sqrt(2/(rho_infinite*S))*(1/c_t)*C_L_b_C_D_max1*(sqrt(W_0)-sqrt(W_1));

E=(1/c_t)*C_L_b_C_D_max*log(W_0/W_1);

/*The  answer may slightly vary due to  rounding off values*/
end Ex6_13;
