class Ex6_19
/*Power convesion from hp to ft.lb/s, 1hp=550 ft.lb/s */

parameter Real pi = Modelica.Constants.pi;

parameter Real rho_infinite(unit="slug/ft^3")=0.002377;/* atmospheric density*/

parameter Real W_fe(unit="lb")=2583;/*fuel empty weight of CP-1*/
parameter Real W_r(unit="lb")=880;/*reduced mass*/
parameter Real W_f(unit="lb")=367;/*weight of fuel*/
Real W_1(unit="lb");/*fuel empty weight of UAV*/
Real W_0(unit="lb");/*gross weight of UAV*/

Real AR=7.37;/*aspect ratio of the aircraft*/
parameter Real C_D0=0.025;/*parasite drag coefficient*/
parameter Real e =0.8;/*span efficiency factor*/
parameter Real S(unit="ft^2")=174;/*wing area of the aircraft*/

/*a*/
parameter Real eta=0.8;/*efficiency of the aircraft's engine*/
parameter Real bhp(unit="hp")=230;/*shaft break horse of the engine*/
Real P_A_hp(unit="hp");/*total power available from engine in horse power unit*/
Real P_A(unit="ft.lb/s");/*total power available from engine in ft.lb/s unit*/

Real V_infinite(unit="ft/s",start=250);/*velocity of the aircraft*/
Real V_max(unit="ft/s");/*attainable maximum velocity*/

/*b*/
Real L_D_max;/*maximum ratio of lift and drag*/
Real R_C_max(unit="ft/s");/*maximum rate of climb*/

/*c*/
parameter Real c(unit="ft^(-1)")=2.27*10^(-7);/*specific fuel consumption in per ft*/
Real C_L_C_D_max;/*maximum ratio of lift coefficient and drag coefficient*/
Real R(unit="ft");/*maximum range*/

/*d*/
Real C_L_C_D_max1;/*maximum C_L^(3/2) by C_D ratio*/
Real E(unit="s");/*maximum endurance*/

equation
/*a*/
W_1=W_fe-W_r;
W_0=W_1+W_f;

P_A_hp=eta*bhp;
P_A=P_A_hp*550;
P_A=(1/2)*rho_infinite*V_infinite^3*S*C_D0+W_0^2/((1/2)*rho_infinite*V_infinite*S*pi*e*AR);
V_max=V_infinite;

/*b*/
L_D_max=(sqrt(C_D0*pi*e*AR))/(2*C_D0);
R_C_max=P_A/W_0-0.8776*sqrt((W_0/S)/(rho_infinite*C_D0))*(1/L_D_max^(3/2));

/*c*/
C_L_C_D_max=L_D_max;
R=(eta/c)*C_L_C_D_max*log(W_0/W_1);

/*d*/
C_L_C_D_max1=(3*C_D0*pi*e*AR)^(3/4)/(4*C_D0);
E=(eta/c)*C_L_C_D_max1*(sqrt(2*rho_infinite*S))*((1/sqrt(W_1))-(1/sqrt(W_0)));
end Ex6_19;
