class Ex6_3
parameter Real pi = Modelica.Constants.pi;

/*Number-a*/
/*for propeller driven aircraft CP-1*/
parameter Integer np=5;

parameter Real W_p(unit="lb")=2950;/*normal gross weight*/
parameter Real b_p(unit="ft")=35.8;/*wingspan of the aircraft*/
parameter Real S_p(unit="ft^2")=174;/*wing area of the aircraft*/
parameter Real e_p =0.8;/*span efficiency factor*/

parameter Real rho_infinite_p(unit="slug/ft^3")=0.002377;/* atmospheric density*/

Real V_p[np](each unit="ft/s")={100,150,250,300,350};/*flight velocity of aircraft*/

Real C_L_p[np];/*lift coefficient*/
Real AR_p;/*aspect ratio of the aircraft*/

parameter Real C_D0_p=0.025;/*parasite drag coefficient*/
Real C_D_p[np];/*total drag coefficient**/
Real L_by_D_p[np];/*ratio between thrust and drag*/

Real T_R_p[np](each unit="lb");/*thrust required for the aircraft*/
Real P_R_p[np](each unit="ft.lb/s");/*power required for the aircraft*/

/*Number-b*/
/*for jet powered aircraft CJ-1*/
parameter Integer n=5;

parameter Real W_j(unit="lb")=19815;/*normal gross weight*/
parameter Real b_j(unit="ft")=53.3;/*wingspan of the aircraft*/
parameter Real S_j(unit="ft^2")=318;/*wing area of the aircraft*/
parameter Real e_j =0.81;/*span efficiency factor*/

parameter Real rho_infinite_j(unit="slug/ft^3")=0.001184;/* atmospheric density*/

Real V_j[n](each unit="ft/s")={300,500,600,800,1000};/*flight velocity of aircraft*/

Real C_L_j[n];/*lift coefficient*/
Real AR_j;/*aspect ratio of the aircraft*/

parameter Real C_D0_j=0.02;/*parasite drag coefficient*/
Real C_D_j[n];/*total drag coefficient**/
Real L_by_D_j[n];/*ratio between thrust and drag*/

Real T_R_j[n](each unit="lb");/*thrust required for the aircraft*/
Real P_R_j[n](each unit="ft.lb/s");/*power required for the aircraft*/

/*Number-a*/
/*for propeller driven aircraft*/
algorithm

for i in 1:np loop
C_L_p[i]:=W_p/((1/2)*rho_infinite_p*V_p[i]^2*S_p);

AR_p:=b_p^2/S_p;

C_D_p[i]:=C_D0_p+C_L_p[i]^2/(pi*e_p*AR_p);

L_by_D_p[i]:=C_L_p[i]/C_D_p[i];

T_R_p[i]:=W_p/L_by_D_p[i];

P_R_p[i]:=T_R_p[i]*V_p[i];
end for;

/*Number-b*/
/*for jet powered aircraft*/
algorithm

for i in 1:n loop
C_L_j[i]:=W_j/((1/2)*rho_infinite_j*V_j[i]^2*S_j);

AR_j:=b_j^2/S_j;

C_D_j[i]:=C_D0_j+C_L_j[i]^2/(pi*e_j*AR_j);

L_by_D_j[i]:=C_L_j[i]/C_D_j[i];

T_R_j[i]:=W_j/L_by_D_j[i];

P_R_j[i]:=T_R_j[i]*V_j[i];
end for;

/*The  answer may slightly vary due to  rounding off values*/
end Ex6_3;
