class Ex6_4

/*Power convesion from hp to ft.lb/s, 1hp=550 ft.lb/s */
parameter Real pi = Modelica.Constants.pi;

/*Number-a*/
/*for propeller driven aircraft CP-1*/
/*for propeller driven aircraft CP-1*/
parameter Integer np=70;

parameter Real W_p(unit="lb")=2950;/*normal gross weight*/
parameter Real b_p(unit="ft")=35.8;/*wingspan of the aircraft*/
parameter Real S_p(unit="ft^2")=174;/*wing area of the aircraft*/
parameter Real e_p =0.8;/*span efficiency factor*/

parameter Real rho_infinite_p(unit="slug/ft^3")=0.002377;/* atmospheric density*/

Real V_p[np](each unit="ft/s");/*flight velocity of aircraft*/

Real C_L_p[np];/*lift coefficient*/
Real AR_p;/*aspect ratio of the aircraft*/

parameter Real C_D0_p=0.025;/*parasite drag coefficient*/
Real C_D_p[np];/*total drag coefficient**/
Real L_by_D_p[np];/*ratio between thrust and drag*/

Real T_R_p[np](each unit="lb");/*thrust required for the aircraft*/
Real P_R_p[np](each unit="ft.lb/s");/*power required for the aircraft*/
Real P_R_p_hp[np](each unit="hp");/*power required for the aircraft in hp unit*/

parameter Real eta_p=0.8;/*efficiency of the propeller driven aircraft's engine*/
parameter Real bhp_p(unit="hp")=230;/*shaft break horse of the engine*/
Real hp_A_p(unit="hp");/*total power available from engine*/
Real V_max_array_p[np](each unit="ft/s");/*array for maximum velocity*/
Real V_max_p(unit="ft/s");/*attainable maximum velocity*/

/*Number-b*/
/*for jet powered aircraft CJ-1*/
/*for jet powered aircraft CJ-1*/
parameter Integer n=70;
parameter Real W_j(unit="lb")=19815;/*normal gross weight*/
parameter Real b_j(unit="ft")=53.3;/*wingspan of the aircraft*/
parameter Real S_j(unit="ft^2")=318;/*wing area of the aircraft*/
parameter Real e_j =0.81;/*span efficiency factor*/

parameter Real rho_infinite_j_0(unit="slug/ft^3")=0.002377;/* atmospheric density at sea level*/
parameter Real rho_infinite_j(unit="slug/ft^3")=0.001184;/* atmospheric density at 22000 ft*/

Real V_j[n](each unit="ft/s");/*flight velocity of aircraft*/

Real C_L_j[n];/*lift coefficient*/
Real AR_j;/*aspect ratio of the aircraft*/

parameter Real C_D0_j=0.02;/*parasite drag coefficient*/
Real C_D_j[n];/*total drag coefficient**/
Real L_by_D_j[n];/*ratio between thrust and drag*/

Real T_R_j[n](each unit="lb");/*thrust required for the aircraft*/
Real P_R_j[n](each unit="ft.lb/s");/*power required for the aircraft*/
Real P_R_j_hp[n](each unit="hp");/*power required for the aircraft in hp unit*/

parameter Real T_A_j0(unit="lb")=2*3650;/*total thrust available at sea level*/
Real hp_A_j[n](each unit="hp");/*total power available from engine*/

Real V_max_array_j[n](each unit="ft/s");/*array for maximum velocity*/
Real V_max_j(unit="ft/s");/*attainable maximum velocity*/

/*Number-a*/
/*for propeller driven aircraft CP-1*/
/*for propeller driven aircraft CP-1*/
algorithm
V_p[1]:=235;

for i in 2:np loop
V_p[i]:=V_p[i-1]+0.5;
end for;

for i in 1:np loop
C_L_p[i]:=W_p/((1/2)*rho_infinite_p*V_p[i]^2*S_p);

AR_p:=b_p^2/S_p;

C_D_p[i]:=C_D0_p+C_L_p[i]^2/(pi*e_p*AR_p);

L_by_D_p[i]:=C_L_p[i]/C_D_p[i];

T_R_p[i]:=W_p/L_by_D_p[i];

P_R_p[i]:=T_R_p[i]*V_p[i];
P_R_p_hp[i]:=P_R_p[i]/550;

hp_A_p:=eta_p*bhp_p;

if(P_R_p_hp[i]>=(hp_A_p-0.2) and P_R_p_hp[i]<=(hp_A_p +0.2)) then
V_max_array_p[i]:=V_p[i];
else
V_max_array_p[i]:=0;
end if;
V_max_p:=max(V_max_array_p);
end for;

/*Number-b*/
/*for jet powered aircraft CJ-1*/
/*for jet powered aircraft CJ-1*/
algorithm
V_j[1]:=940;

for i in 2:n loop
V_j[i]:=V_j[i-1]+0.5;
end for;

for i in 1:n loop
C_L_j[i]:=W_j/((1/2)*rho_infinite_j*V_j[i]^2*S_j);

AR_j:=b_j^2/S_j;

C_D_j[i]:=C_D0_j+(C_L_j[i]^2)/(pi*e_j*AR_j);

L_by_D_j[i]:=C_L_j[i]/C_D_j[i];

T_R_j[i]:=W_j/L_by_D_j[i];

P_R_j[i]:=T_R_j[i]*V_j[i];

P_R_j_hp[i]:=P_R_j[i]/550;

hp_A_j[i]:=((rho_infinite_j/rho_infinite_j_0)*T_A_j0*V_j[i])/550;

if(P_R_j_hp[i]>=(hp_A_j[i]-1) and P_R_j_hp[i]<=(hp_A_j[i] +1)) then
V_max_array_j[i]:=V_j[i];
else
V_max_array_j[i]:=0;
end if;
V_max_j:=max(V_max_array_j);
end for;

/*The  answer may slightly vary due to  rounding off values*/
end Ex6_4;
