class Ex1_5
parameter Real p1(unit="N/m^2")=20712.9;/*free stream pressure at 11582.4 m*/
parameter Real T1(unit="K")=216.67;/*free stream temperature at 11582.4 m*/
parameter Real T2(unit="K")=238.88;/*temperature at wind tunnel test section*/
parameter Real c1_c2=50;/*ratio of chord of wing of the actual aircraft and the model aircraft*/
Real rho1_rho2;/*ratio of free stream air density and the wind tunnel air density*/
parameter Real V1(unit="m/s")=245.87;/*aircraft cruising velocity*/
Real V2(unit="m/s");/*air velocity at wind tunnel test section*/
Real p2(unit="N/m^2");/*pressure at wind tunnel test section*/
equation
V2=V1*sqrt(T2/T1); 
rho1_rho2=c1_c2;
p2/p1=rho1_rho2*(T2/T1);
/*The  answer may slightly vary due to  rounding off values*/
end Ex1_5;
