class Ex1_8
/*Number-1*/
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real D(unit="m")=9.14;/*diameter of the ballon*/
Real r(unit="m");/*radius of the ballon*/
parameter Real rho_1(unit="kg/m^3")=1.225;/* atmospheric density at sea level*/
Real v(unit="m^3");/*volume of the inflated baloon*/
Real B(unit="N");/*buoyancy force on ballon at sea level*/
parameter Real W(unit="N")=3558.58;/*weight of the ballon*/
Real m(unit="kg");/*mass of the ballon*/
Real a(unit="m/s^2");/*acceleration of the ballon at sea level*/

/*Number-b*/
Real B1(unit="N");/*buoyancy force on ballon at maximum altitude*/
Real rho_2(unit="kg/m^3");/* atmospheric density at maximum altitude*/
Real h(unit="m");/*achievable maximum altitude*/

equation
/*Number-a*/
r=D/2;
v=(4/3)*3.14*r^3;
B=g*rho_1*v;
m=W/g;
a=(B-W)/m;

/*Number-b*/
B1=W;
rho_2=B1/(g*v);
rho_2=1.225*(1-2.297*10^(-5)*h)^4.21;
/*The  answer may slightly vary due to  rounding off values*/
end Ex1_8;
