class Ex12_2
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg.K")=287;/*Specific Gas Constant*/

parameter Real g(unit="m/s^2")=9.8;/*acceleration due to gravity*/

parameter Real W_kgf(unit="kgf")=9400;/*weight of the aircraft in kgf*/
Real W_N(unit="N");/*weight of the aircraft in N*/
parameter Real S(unit="m^2")=18.21;/*wing planform area of the aircraft*/
Real M=2;/*Mach number of the aircraft*/

parameter Real rho_inf(unit="kg/m^3")=0.3648;/* atmospheric density at 11 km altitude*/
parameter Real T_inf(unit="K")=216.78;/* atmospheric temperature at 11 km altitude*/
Real a_inf(unit="m/s");/*speed of sound at 11 km altitude*/
Real V_inf(unit="m/s");/*velocity of the aircraft*/
Real q_inf(unit="N/m^2");/*dynamic pressure on the aircraft(given unit of q_inf in the book is wrong )*/

Real C_L;/*lift coefficient of the aircraft*/

Real alpha_rad(unit="rad");/*angle of attack of the aircraft in radian*/
Real alpha_deg(unit="deg");/*angle of attack of the aircraft in degree*/
equation
a_inf=sqrt(gama*R*T_inf);
V_inf=M*a_inf;
q_inf=(1/2)*rho_inf*V_inf^2;

W_N=W_kgf*g;
C_L=W_N/(q_inf*S);

C_L=(4*alpha_rad)/sqrt(M^2-1);
alpha_deg=Modelica.SIunits.Conversions.to_deg(alpha_rad);
end Ex12_2;
