class Ex19_1
parameter Real rho_inf(unit="kg/m^3")=1.22;/*air density of the flow*/
parameter Real S(unit="m^2")=40;/*planform area of the plate*/

/*Number-a*/
parameter Real Re_c_a=1.36*10^7;/*Reynolds number for case a*/
parameter Real V_inf_a(unit="m/s")=100;/*free stream velocity for case a*/
Real C_f_a;/*skin friction coefficient for case a*/
Real D_f_a(unit="N");/* friction drag on one surface of the plate for case a*/
Real D_a(unit="N");/*total friction drag for case a*/

/*Number-b*/
parameter Real Re_c_b=1.36*10^8;/*Reynolds number for case b*/
parameter Real V_inf_b(unit="m/s")=1000;/*free stream velocity for case b*/
parameter Real C_f_b=1.34*10^(-3);/*skin friction coefficient for case b*/
Real D_f_b(unit="N");/* friction drag on one surface of the plate for case b*/
Real D_b(unit="N");/*total friction drag for case b*/

equation
/*Number-a*/
C_f_a=0.074/Re_c_a^(1/5);
D_f_a=(1/2)*rho_inf*V_inf_a^2*S*C_f_a;
D_a=2*D_f_a;

/*Number-a*/
D_f_b=(1/2)*rho_inf*V_inf_b^2*S*C_f_b;
D_b=2*D_f_b;
/*The  answer may slightly vary due to  rounding off values*/
end Ex19_1;
