class Ex19_2
parameter Real S(unit="m^2")=40;/*planform area of the plate*/

parameter Real rho_star(unit="kg/m^3")=0.574;/*reference density*/
parameter Real u_e(unit="m/s")=1000;/*free stream velocity*/
parameter Real Re_c_star=3.754*10^7;/*reference Reynolds number*/

Real C_f_star;/*reference skin friction coefficient*/

Real D_f(unit="N");/* friction drag on one side of the plate*/
Real D(unit="N");/*total friction drag*/

equation
/*Number-a*/
C_f_star=0.074/Re_c_star^(1/5);
D_f=(1/2)*rho_star*u_e^2*S*C_f_star;
D=2*D_f;
/*The  answer may slightly vary due to  rounding off values*/
end Ex19_2;
