class Ex3_4
parameter Real g(unit="m/s^2")=9.8;/*acceleration due to gravity*/
parameter Real contract_ratio=12/1;/*contraction ratio of the nozzle*/
Real p1_p2(unit="N/m^2");/*pressure difference between the inlet and test section*/ 
parameter Real rho(unit="kg/m^3")=1.23;/*air density at sea level*/
Real A2_A1;/*ratio of test section crossectional area and inlet crossectional area*/
parameter Real V2(unit="m/s")=50;/*velocity of the flow at the test section*/
parameter Real rho_m(unit="kg/m^3")=1.36*10^4;/*liquid density of mercury*/
Real w(unit="N/m^2");/*specific weight*/
Real del_h(unit="m");/*height difference in a U-tube mercury manometer*/
equation
A2_A1=1/contract_ratio;
p1_p2=(1/2)*rho*V2^2*(1-A2_A1^2);
w=rho_m*g;
del_h=p1_p2/w;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_4;
