class Ex3_5
parameter Real L_max(unit="N")=4448.22;/*maximum allowable lift*/
parameter Real S(unit="m^2")=0.56;/*wing planform area*/
parameter Real C_Lmax=1.3;/*maximum lift coefficient*/
parameter Real rho_infinite(unit="kg/m^3")=1.225;/*air density at sea level*/
Real V_infinite(unit="m/s");/*free sream velocity at maximumlift*/

parameter Real contract_ratio=12/1;/*contraction ratio of the nozzle*/
Real A2_A1;/*ratio of test section crossectional area and settling chamber crossectional area*/
Real p1_p2(unit="Pa");/*maximum pressure difference between settling chamber and test section*/ 
equation
L_max=(1/2)*rho_infinite*V_infinite^2*S*C_Lmax;

A2_A1=1/contract_ratio;
p1_p2=(1/2)*rho_infinite*V_infinite^2*(1-A2_A1^2);
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_5;
