class Ex4_4
parameter Real pi = Modelica.Constants.pi;

/*Number-a*/
parameter Real alpha_deg(unit="deg")=5;/*angle of attack in degree*/
Real alpha(unit="rad");/*angle of attack in radian*/
Real c_l;/*lift coefficient*/

/*Number-b*/
Real c_m_le;/*moment coefficient about the leading edge*/

/*Number-c*/
Real c_m_c4;/*moment coefficient about the quarter cord point*/

/*Number-d*/
Real c_m_te;/*moment coefficient about the trailing edge*/

equation
/*Number-a*/
alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
c_l=2*pi*alpha;

/*Number-b*/
c_m_le=-c_l/4;

/*Number-c*/
c_m_c4=0;

/*Number-d*/
c_m_te=(3/4)*c_l+c_m_c4;
end Ex4_4;
