class Ex8_1
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg*K")=287;/*Specific Gas Constant of Air*/

parameter Real V(unit="m/s")=250;/*airplane flying velocity*/

/*Number-a*/
parameter Real T_infinite_s(unit="K")=288;/*free stream temperature at sea level*/
Real a_infinite_s(unit="m/s");/*speed of sound at sea level*/
Real M_infinite_s;/*Mach number at sea level*/

/*Number-b*/
parameter Real T_infinite_5(unit="K")=255.7;/*free stream temperature at 5km altitude*/
Real a_infinite_5(unit="m/s");/*speed of sound at 5km altitude*/
Real M_infinite_5;/*Mach number at 5km altitude*/

/*Number-c*/
parameter Real T_infinite_10(unit="K")=223.3;/*free stream temperature at 10km altitude*/
Real a_infinite_10(unit="m/s");/*speed of sound at 10km altitude*/
Real M_infinite_10;/*Mach number at 10km altitude*/

equation
/*Number-a*/
a_infinite_s=sqrt(gama*R*T_infinite_s);
M_infinite_s=V/a_infinite_s;

/*Number-b*/
a_infinite_5=sqrt(gama*R*T_infinite_5);
M_infinite_5=V/a_infinite_5;

/*Number-c*/
a_infinite_10=sqrt(gama*R*T_infinite_10);
M_infinite_10=V/a_infinite_10;

/*The  answer may slightly vary due to  rounding off values*/
end Ex8_1;

