class Ex8_11
/*pressure conversion from atm to N/m^2, 1 atm=1.02*10^5, */

parameter Real M_inf=10;/*Mach number of the flying ramjet*/

parameter Real p_inf(unit="N/m^2")=2.65*10^4;/*freestream pressure*/
parameter Real T_inf(unit="K")=223.3;/*freestream temperature*/

parameter Real p_0inf_by_p_inf=0.4244*10^5;/*ratio of free stream total pressure and static pressure*/
Real p_0inf(unit="N/m^2");/*free stream total pressure*/

parameter Real T_0inf_by_T_inf=21;/*ratio of free stream total temperature and static temperature*/
Real T_0inf(unit="K");/*free stream total temperature*/

parameter Real p_01_by_p_0inf=0.3045*10^(-2);/*ratio of  total pressure of behind and ahead of point 1*/
Real p_01(unit="N/m^2");/*total pressure of behind of point 1*/
Real T_01(unit="K");/*total temperature of behind of point 1*/

Real p_02(unit="N/m^2");/*total pressure of ahead of point 2*/
Real T_02(unit="K");/*total temperature of ahead of point 2*/

parameter Real p_2_by_p_02=1/1.028;/*ratio of  total-to-static pressure at point 2*/
Real p_2(unit="N/m^2");/*static preesure at point 2*/
Real p_2_atm(unit="atm");/*static preesure at point 2 in atm unit*/

parameter Real T_2_by_T_02=1/1.008;/*ratio of  total-to-static temperature at point 2*/
Real T_2(unit="K");/*static temperature at point 2*/

equation
p_0inf=p_0inf_by_p_inf*p_inf;
T_0inf=T_0inf_by_T_inf*T_inf;

p_01=p_01_by_p_0inf*p_0inf;
T_01=T_0inf;

p_02=p_01;
T_02=T_01;

p_2=p_2_by_p_02*p_02;
p_2_atm=p_2/(1.02*10^5);

T_2=T_2_by_T_02*T_02;

/*The  answer may slightly vary due to  rounding off values*/
end Ex8_11;
