class Ex8_13
/*pressure conversion from atm to N/m^2, 1 atm=1.013*10^5, */

parameter Real p_1(unit="N/m^2")=4.66*10^4;/*freestream pressure*/
parameter Real p_02_by_p_1=82.87;/*ratio of total pressure behind the shock and static pressure ahead of shock*/
Real p_02(unit="N/m^2");/*total pressure behind the shock*/
Real p_s(unit="N/m^2");/*pressure at the stagnation point of the nose*/
Real p_s_atm(unit="atm");/*pressure at the stagnation point of the nose in atmospheric unit*/
equation
p_02=p_02_by_p_1*p_1;
p_s=p_02;
p_s_atm=p_s/(1.013*10^5);
end Ex8_13;
