class Ex8_14
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg*K")=287;/*Specific Gas Constant of Air*/

parameter Real T(unit="K")=216.66;/*freestream temperature at altitude 25km*/
parameter Real p_1(unit="N/m^2")=2.5273*10^3;/*freestream pressure at altitude 25km*/
parameter Real p_01(unit="N/m^2")=3.88*10^4;/*total pressure of free stream*/

Real p_01_by_p_1;/*ratio of free stream total pressure and static pressure*/
Real M1;/*Mach number of the aircraft*/
Real a1(unit="m/s");/*speed of sound at altitude 25km*/
Real V1(unit="m/s");/*velocity of the airlane*/
equation
p_01_by_p_1=p_01/p_1;
M1=3.4;
a1=sqrt(gama*R*T);
V1=M1*a1;

/*The  answer may slightly vary due to  rounding off values*/
end Ex8_14;
