class Ex8_2
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg*K")=287;/*Specific Gas Constant of Air*/

parameter Real T(unit="K")=320;/*temperature at a point in the flow*/
parameter Real V(unit="m/s")=1000;/*velocity at a point in the flow*/

Real a(unit="m/s");/*speed of sound through the airflow*/
Real M;/*Mach number of the flow*/
equation
a=sqrt(gama*R*T);
M=V/a;
end Ex8_2;
