class Ex8_8
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg*K")=287;/*Specific Gas Constant of Air*/

parameter Real u1(unit="m/s")=680;/*upstream velocity*/
parameter Real T1(unit="K")=288;/*upstream temperature*/
parameter Real p1(unit="atm")=1;/*upstream pressure*/

Real a1(unit="m/s");/*speed of sound through upstream*/
Real M1;/*upstream Mach number*/

parameter Real p2_by_p1=4.5;/*ratio of downstream pressure and upstream pressure*/ 
parameter Real T2_by_T1=1.687;/*ratio of downstream temperature and upstream temperature*/
parameter Real M2=0.5774;/*downstream Mach number*/

Real T2(unit="K");/*downstream temperature*/
Real p2(unit="atm");/*downstream pressure*/

Real a2(unit="m/s");/*speed of sound through downstream*/
Real u2(unit="m/s");/*velocity of downstream flow*/

equation
a1=sqrt(gama*R*T1);
M1=u1/a1;
p2=p2_by_p1*p1;
T2=T2_by_T1*T1;
a2=sqrt(gama*R*T2);
u2=M2*a2;
end Ex8_8;
