class Ex9_11
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real M_1=3;/*Mach number of the flow ahead of expansion wave*/
parameter Real p1(unit="atm")=1;/*pressure ahead of expansion wave*/
 
parameter Real alpha_deg(unit="deg")=5;/*angle of attack of the plate in degree*/
Real alpha_rad(unit="rad");/*angle of attack of the plate in radian*/
Real theta_deg(unit="deg");/*deflection angle in degree for oblique shock*/
Real theta_rad(unit="rad");/*deflection angle in radian for oblique shock*/
parameter Real nu1(unit="deg")=49.76;/*value of the Prandtl-Meyer function ahead of expansion wave*/
Real nu2(unit="deg");/*value of the Prandtl-Meyer function behind the expansion wave*/

parameter Real M_2=3.27;/*Mach number of the flow behind of expansion wave*/
parameter Real p01_by_p1=36.73;/*ratio of total pressure to static pressure ahead of expansion wave*/

parameter Real p02_by_p2=55;/*ratio of total pressure to static pressure behind of expansion wave*/

Real p2_by_p1;/*ratio of static pressure ahead and behind of expansion wave*/ 


parameter Real beta_deg(unit="deg")=23.1;/*wave angle in degree for oblique shock*/
Real beta_rad(unit="rad");/*wave angle in radian for oblique shock*/

Real M_n1;/*normal component of Mach number ahead of oblique shock*/
parameter Real p3_by_p1=1.458;/*ratio of static pressure ahead and behind of oblique wave*/

Real c_l;/*lift coefficient of the flat plate*/
Real c_d;/*drag coefficient of the flat plate*/

equation
alpha_rad=Modelica.SIunits.Conversions.from_deg(alpha_deg);
theta_deg=alpha_deg;
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
beta_rad=Modelica.SIunits.Conversions.from_deg(beta_deg);

nu2=nu1+theta_deg;

p2_by_p1=p01_by_p1/p02_by_p2;
M_n1=M_1*sin(beta_rad);

c_l=(2/(gama*M_1^2))*(p3_by_p1-p2_by_p1)*cos(alpha_rad);
c_d=(2/(gama*M_1^2))*(p3_by_p1-p2_by_p1)*sin(alpha_rad);

/*The  answer may slightly vary due to  rounding off values*/
end Ex9_11;
