class Ex9_3
parameter Real M_1=2.4;/*upstream flow Mach number*/

parameter Real beta_deg(unit="deg")=30;/*wave angle in degree*/
Real beta_rad(unit="rad");/*wave angle in radian*/
Real M_n1;/*normal component of Mach number ahead of shock*/

Real theta_deg(unit="deg");/*deflection angle in degree*/
Real theta_rad(unit="rad");/*deflection angle in radian*/

Real p_2_by_p_1;/*ratio of pressure of ahead and behind of the shock*/
Real T_2_by_T_1;/*ratio of temperature of ahead and behind of the shock*/
Real M_n2;/*normal component of Mach number behind of shock*/

Real M_2;/*Mach number of the stream behind the shock*/

equation
beta_rad=Modelica.SIunits.Conversions.from_deg(beta_deg);
M_n1=M_1*sin(beta_rad);

theta_deg=6.5;
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);

p_2_by_p_1=1.513;
T_2_by_T_1=1.128;

M_n2=0.8422;
M_2=M_n2/sin(beta_rad-theta_rad);
end Ex9_3;
