class Ex9_8
parameter Real M_1=1.5;/*Mach number of the flow ahead of expansion wave*/
parameter Real p1(unit="atm")=1;/*pressure ahead of expansion wave*/ 
parameter Real T1(unit="K")=288;/*Temperature ahead of expansion wave*/

parameter Real theta(unit="deg")=15;/*deflection angle of the flow*/
parameter Real nu1(unit="deg")=11.91;/*value of the Prandtl-Meyer function ahead of expansion wave*/
Real nu2(unit="deg");/*value of the Prandtl-Meyer function behind the expansion wave*/

parameter Real M_2=2;/*Mach number of the flow behind of expansion wave*/
parameter Real p01_by_p1=3.671;/*ratio of total pressure to static pressure ahead of expansion wave*/
parameter Real T01_by_T1=1.45;/*ratio of total temperature to static temperature ahead of expansion wave*/

parameter Real p02_by_p2=7.824;/*ratio of total pressure to static pressure behind of expansion wave*/
parameter Real T02_by_T2=1.8;/*ratio of total temperature to static temperature behind of expansion wave*/

Real p2(unit="atm");/*pressure behind of expansion wave*/ 
Real T2(unit="K");/*Temperature behind of expansion wave*/

Real p01(unit="atm");/*total pressure ahead of expansion wave*/
Real T01(unit="K");/*total temperature ahead of expansion wave*/
Real p02(unit="atm");/*total pressure behind of expansion wave*/
Real T02(unit="K");/*total temperature behind of expansion wave*/

Real mu1(unit="deg");/*angle of forward Mach line*/
Real mu2(unit="deg");
Real Angle(unit="deg");/*angle of rearward Mach line*/
equation
nu2=nu1+theta;

p01=p01_by_p1*p1;
T01=T01_by_T1*T1;

p02=p01;
T02=T01;

p2=(1/p02_by_p2)*(p02/p01)*p01_by_p1*p1;
T2=(1/T02_by_T2)*(T02/T01)*T01_by_T1*T1;
mu1=41.81;
mu2=30;
Angle=mu2-theta;

end Ex9_8;
