package Ex10_2

model Ex10_2_a

parameter Real A_e_A_star=2;/*exit to throat area ratio*/
parameter Real T_0(unit="K")=288;/*temperature in the reservoir*/
parameter Real p_0(unit="atm")=1;/*pressure in the reservoir*/

parameter Real p_star_p_0=0.528;/*ratio of throat pressure to reservior pressure*/
parameter Real T_star_T_0=0.833;/*ratio of throat temperature to reservior temperature*/

Real M_t;/*Mach number at the throat*/
Real p_t(unit="atm");/*pressure at the throat*/
Real T_t(unit="K");/*temperature at the throat*/

parameter Real p_e_p_0=1/10.69;/*ratio of exit pressure to reservior pressure*/
parameter Real T_e_T_0=1/1.968;/*ratio of exit temperature to reservior temperature*/

Real M_e;/*Mach number at the exit*/
Real p_e(unit="atm");/*pressure at the exit*/
Real T_e(unit="K");/*temperature at the exit*/
equation
M_t=1;
p_t=p_star_p_0*p_0;
T_t=T_star_T_0*T_0;

M_e=2.2;
p_e=p_e_p_0*p_0;
T_e=T_e_T_0*T_0;
/*The  answer may slightly vary due to  rounding off values*/
end Ex10_2_a;

model Ex10_2_b
parameter Real A_e_A_star=2;/*exit to throat area ratio*/
parameter Real T_0(unit="K")=288;/*temperature in the reservoir*/
parameter Real p_0(unit="atm")=1;/*pressure in the reservoir*/

parameter Real p_e_p_0=1/1.064;/*ratio of exit pressure to reservior pressure*/
parameter Real T_e_T_0=1/1.018;/*ratio of exit temperature to reservior temperature*/

Real M_e;/*Mach number at the exit*/
Real p_e(unit="atm");/*pressure at the exit*/
Real T_e(unit="K");/*temperature at the exit*/

equation
M_e=0.3;
p_e=p_e_p_0*p_0;
T_e=T_e_T_0*T_0;
/*The  answer may slightly vary due to  rounding off values*/
end Ex10_2_b;

end Ex10_2;
