class Ex16_1
parameter Real u_e(unit="m/s")=60.96;/*velocity of the upper wall*/
parameter Real D(unit="m")=2.54*10^(-4);/*distance between the plates*/
parameter Real mu(unit="kg/m.s")=1.7894*10^(-5);/*viscosity of the flow*/
parameter Real T_w(unit="K")=288.3;/*temperature of lower the plate*/
parameter Real T_e(unit="K")=288.3;/*temperature of upper the plate*/
parameter Real y_D=1/2;/*mid position of the flow as a fraction of distance between wall*/
parameter Real Pr=0.71;/*Prandtl number*/
parameter Real c_p(unit="J.kg^(-1).K^(-1)")=1004.5;/*specific heat at constant pressure of air*/

/*Number-a*/
Real u(unit="m/s");/*velocity in the middle of the wall*/

/*Number-b*/ 
Real tau_w(unit="N/m^2");/*shear stress*/

/*Number-c*/
Real T(unit="K"); /*maximum temperature in the flow*/

/*Number-d*/
Real q_dot_w(unit="N.m^(-1).s^(-1)");/*heat transfer to either wall*/

/*Number-e*/
Real T_aw(unit="K");/*temperature at the condition of adiabatic lower wall*/
equation

/*Number-a*/
u=u_e*y_D;

/*Number-b*/
tau_w=mu*(u_e/D);

/*Number-c*/
T=T_w+(Pr/c_p)*(u_e^2/2)*(y_D-y_D^2);

/*Number-d*/
q_dot_w=(mu/2)*(u_e^2/D);

/*Number-e*/
T_aw=T_e+(Pr/c_p)*(u_e^2/2);
end Ex16_1;
