class Ex3_13
parameter Real pi = Modelica.Constants.pi;
parameter Real C_p=0;/*pressure coefficient at stagnation point*/
Real theta(unit="rad",max=2*pi);/*angular position of stagnation point in radian*/
Real theta_deg(unit="deg");/*angular position of stagnation point in degree*/
equation
C_p=1-4*(sin(theta))^2;
theta_deg=Modelica.SIunits.Conversions.to_deg(theta);
end Ex3_13;
