class Ex9_9
parameter Real M_1=10;/*Mach number of the flow ahead of compression wave*/
parameter Real p1(unit="atm")=1;/*pressure ahead of compression wave*/ 

parameter Real theta(unit="deg")=15;/*turned angle of the flow*/
parameter Real nu1(unit="deg")=102.3;/*value of the Prandtl-Meyer function ahead of compression wave*/
Real nu2(unit="deg");/*value of the Prandtl-Meyer function behind the compression wave*/

parameter Real M_2=6.4;/*Mach number of the flow behind of compression wave*/
parameter Real p01_by_p1=0.4244*10^5;/*ratio of total pressure to static pressure ahead of compression wave*/

parameter Real p02_by_p2=0.2355*10^4;/*ratio of total pressure to static pressure behind of compression wave*/

Real p01(unit="atm");/*total pressure ahead of expansion wave*/
Real p02(unit="atm");/*total pressure behind of expansion wave*/

Real p2(unit="atm");/*pressure behind of compression wave*/ 
equation
nu2=nu1-theta;

p01=p01_by_p1*p1;

p02=p01;

p2=(1/p02_by_p2)*(p02/p01)*p01_by_p1*p1;

end Ex9_9;
