package Ex12_3
model Ex12_3_a
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg.K")=287;/*Specific Gas Constant*/

parameter Real c(unit="m")=2.2;/*chord length of the airfoil*/
parameter Real M=2;/*Mach number of the aircraft*/

parameter Real rho_inf(unit="kg/m^3")=0.3648;/* atmospheric density at 11 km altitude*/
parameter Real T_inf(unit="K")=216.78;/* atmospheric temperature at 11 km altitude*/
Real a_inf(unit="m/s");/*speed of sound at 11 km altitude*/
Real V_inf(unit="m/s");/*velocity of the aircraft*/

parameter Real T_0(unit="K")=288.16;/* atmospheric temperature at sea level*/
parameter Real mu_0(unit="kg/m.s")=1.7894*10^(-5);/*viscosity of the air at sea level*/
Real mu(unit="kg/m.s");/*viscosity of the air at 11 km altitude*/
Real Re_c;/*Reynolds number at tralling edge of the wing*/

Real C_f;/*airfoil skin-friction drag coefficient for single surface*/
Real C_f_net;/*total skin-friction drag coefficient for both surface of the airfoil*/

equation
a_inf=sqrt(gama*R*T_inf);
V_inf=M*a_inf;

mu/mu_0=(T_inf/T_0)^(3/2)*((T_0+110)/(T_inf+110));
Re_c=(rho_inf*V_inf*c)/mu;

C_f=2.15*10^(-3);
C_f_net=2*C_f;
end Ex12_3_a;

model Ex12_3_b
parameter Real M=2;/*Mach number of the aircraft*/
parameter Real alpha(unit="rad")=0.035;/*angle of attack of the aircraft*/
Real c_d;/*airfoil wave drag coefficient*/
equation
c_d=(4*alpha^2)/sqrt(M^2-1);
end Ex12_3_b;

end Ex12_3;
