class Ex3_1
parameter Real p_infinite(unit="N/m^2")=1.01*10^5;/*pressure of free stream air*/
parameter Real V_infinite(unit="m/s")=50;/*free stream velocity */

parameter Real rho(unit="kg/m^3")=1.23;/*density of free stream air*/

parameter Real p(unit="N/m^2")=0.9*10^5;/*pressure at given point of the airfoil*/
Real V(unit="m/s");/*velocity at given point of the airfoil*/

equation
p_infinite+(rho*V_infinite^2)/2=p+(rho*V^2)/2;
end Ex3_1;
