class Ex3_16
parameter Real pi = Modelica.Constants.pi;

parameter Real D(unit="m")=0.5;/*diameter of the cylinder*/
Real R(unit="m");/*Radius of the cylinder*/
parameter Real rho_infinite(unit="kg/m^3")=0.90926;/* atmospheric density at 3km*/
parameter Real theta(unit="rad")=pi/2;/*angular position of maximum velocity point*/
parameter Real V_infinte(unit="m/s")=25;/*free stream velocity*/
parameter Real V_theta(unit="m/s")=-75;/*maximum velocity on the surface of the cylinder*/
Real gamma(unit="m^2/s");/*circulation of the cylinder*/
Real L_das(unit="N");/*lift per unit span*/
equation
R=D/2;
V_theta=-2*V_infinte*sin(theta)-gamma/(2*pi*R);
L_das=rho_infinite*V_infinte*gamma;
end Ex3_16;
