class Ex3_3
parameter Real throat_to_inlet=0.8;/*throat to inlet area ratio*/
parameter Real p1_p2(unit="Pa")=335.16;/*pressure difference between the inlet and throat*/ 
parameter Real rho(unit="kg/m^3")=1.225;/*air density at sea level*/
Real A1_A2;/*ratio of inlet crossectional area and throat crossectional area*/
Real V1(unit="m/s");/*velocity of the flow at the inlet*/
equation
A1_A2=1/throat_to_inlet;
V1=sqrt((2*p1_p2)/(rho*(A1_A2^2-1)));
end Ex3_3;
