class Ex5_1
/*Conversion from radian to degree 1 radian=180/pi degree*/
parameter Real pi = Modelica.Constants.pi;

parameter Real AR=8;/*aspect ratio of the wing*/
parameter Real delta=0.055;/*induced drag factor*/
Real tau;

parameter Real a_0(unit="per rad")=2*pi;/*lift curve slope for airfoil*/
Real a(unit="rad^(-1)");/*lift curve slope for an finite wing in radian*/
Real a_deg(unit="deg^(-1)");/*lift curve slope for an finite wing in degree unit*/

parameter Real alpha(unit="deg")=5;/*angle of attack*/
Real C_L;/*lift coefficient at 5 deg angle of attack*/

Real C_Di;/*induced drag coefficient*/
equation
tau=delta;
a=a_0/(1+((a_0*(1+tau))/(pi*AR)));
a_deg=a/(180/pi);
C_L=a_deg*alpha;
C_Di=(C_L^2/(pi*AR))*(1+tau);
/*The  answer may slightly vary due to  rounding off values*/
end Ex5_1;
