class Ex5_2
/*Conversion from radian to degree 1 radian=180/pi degree*/
/*Conversion from degree to radian 1 degree=pi/180 radian*/
parameter Real pi = Modelica.Constants.pi;

/*for wing 1*/
parameter Real AR_1=6;/*aspect ratio of the wing 1*/
parameter Real delta=0.055;/*induced drag factor*/
Real tau;

parameter Real alpha_0(unit="deg")=-2;/*zero lift angle of attack*/
parameter Real C_L_0=0;/*lift coefficient at alpha_L_0 */
parameter Real alpha(unit="deg")=3.4;/* angle of attack*/

parameter Real C_Di_1=0.01;/*induced drag coefficient of the wing 1*/
Real C_L_1;/*lift coefficient at alpha for the wing 1*/
Real dC_L_dalpha_deg_1(unit="per deg");/*lift curve slope of the wing 1 in degree*/
Real dC_L_dalpha_1(unit="per rad");/*lift curve slope of the wing 1 in radian*/
Real a_1(unit="per rad");/*lift curve slope of the wing 1*/

Real a_0(unit="per rad");/*lift curve slope of the airfoil*/

/*for wing 2*/
parameter Real AR_2=10;/*aspect ratio of the wing 2*/
Real a_2(unit="per rad");/*lift curve slope of the wing 2*/
Real a_2_deg(unit="per deg");/*lift curve slope of the wing 2 in degree*/

Real C_L_2;/*lift coefficient at alpha for the wing 2*/
Real C_Di_2;/*induced drag coefficient of the wing 2*/

equation
/*for wing 1*/
tau=delta;
C_L_1=sqrt((pi*AR_1*C_Di_1)/(1+tau));
dC_L_dalpha_deg_1=(C_L_1-C_L_0)/(alpha-alpha_0);
dC_L_dalpha_1=dC_L_dalpha_deg_1/(pi/180);
a_1=dC_L_dalpha_1;
a_1=a_0/(1+((a_0*(1+tau))/(pi*AR_1)));

/*for wing 2*/
a_2=a_0/(1+((a_0*(1+tau))/(pi*AR_2)));
a_2_deg=a_2/(180/pi);
C_L_2=a_2_deg*(alpha-alpha_0);
C_Di_2=(C_L_2^2/(pi*AR_2))*(1+tau);
/*The  answer may slightly vary due to  rounding off values*/
end Ex5_2;
