class Ex8_4
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real M=2.79;/*local Mach number*/

parameter Real T(unit="K")=320;/*temperature at a point in the airfoil*/
Real T_0(unit="K");/*total temperature at a point in the airfoil*/

parameter Real p(unit="atm")=1;/*pressure at a point in the airfoil*/
Real p_0(unit="atm");/*total pressure at a point in the airfoil*/

equation
T_0/T=1+((gama-1)/2)*M^2;
p_0/p=(1+((gama-1)/2)*M^2)^(gama/(gama-1));
end Ex8_4;
