package Ex10_4
model Ex10_4_a
/*pressure conversion from atm to N/m^2, 1 atm=1.01*10^5 N/m^2,*/
/*force conversion from Newton to lb 1N=0.2247 lb,*/

parameter Real gama=1.22;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg.K")=520;/*Specific Gas Constant*/

parameter Real p_0(unit="atm")=30;/*pressure in the combustion chamber in atmospheric unit*/
Real p_0_SI(unit="N/m^2");/*pressure in the combustion chamber in SI units*/

parameter Real T_0(unit="K")=3500;/*temperature in the combustion chamber*/
Real T_star(unit="K");/*temperature at the throat*/

Real rho_0(unit="kg/m^3");/*density in the combustion chamber*/
Real rho_star(unit="kg/m^3");/*density in the throat*/

Real a_star(unit="m/s");/*speed of sound at the throat*/
Real u_star(unit="m/s");/*velocity of gas at the throat*/
parameter Real A_star(unit="m^2")=0.4;/*area of the throat*/
Real m_dot(unit="kg/s");/*mass flow rate*/

parameter Real p_infinite(unit="N/m^2")=5.5293*10^3;/*ambient pressure at 20 km altitude*/
Real p_e(unit="N/m^2");/*exit pressure*/
Real M_e;/*exit Mach number*/
Real T_e(unit="K");/*exit temperature*/
Real a_e(unit="m/s");/*speed of sound at the exit*/
Real u_e(unit="m/s");/*velocity of gas at the exit*/

Real T(unit="N");/*thrust in SI unit*/
Real T_lb(unit="lb");/*thrust in lb unit*/
equation
p_0_SI=p_0*1.01*10^5;
rho_0=p_0_SI/(R*T_0);
rho_star/rho_0=(2/(gama+1))^(1/(gama-1));
T_star/T_0=2/(gama+1);

a_star=sqrt(gama*R*T_star);
u_star=a_star;
m_dot=rho_star*u_star*A_star;

p_e=p_infinite;
p_0_SI/p_e=(1+((gama-1)/2)*M_e^2)^(gama/(gama-1));
T_0/T_e=1+((gama-1)/2)*M_e^2;
a_e=sqrt(gama*R*T_e);
u_e=M_e*a_e;

T=m_dot*u_e;
T_lb=T*0.2247;
/*The  answer may slightly vary due to  rounding off values*/
end Ex10_4_a;

model Ex10_4_b
parameter Real gama=1.22;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real A_star(unit="m^2")=0.4;/*area of the throat*/
parameter Real M_e=4.38;/*exit Mach number*/

Real A_e(unit="m^2",max=20);/*area of the nozzle exit*/
equation
(A_e/A_star)^2=(1/M_e^2)*((2/(gama+1))*(1+((gama-1)/2)*M_e^2))^((gama+1)/(gama-1));
end Ex10_4_b;
end Ex10_4;
