class Ex10_5
/*pressure conversion from atm to N/m^2, 1 atm=1.01*10^5 N/m^2,*/

parameter Real gama=1.22;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg.K")=520;/*Specific Gas Constant*/

parameter Real p_0(unit="atm")=30;/*pressure in the combustion chamber in atmospheric unit*/
Real p_0_SI(unit="N/m^2");/*pressure in the combustion chamber in SI units*/

parameter Real T_0(unit="K")=3500;/*temperature in the combustion chamber*/

parameter Real A_star(unit="m^2")=0.4;/*area of the throat*/

Real m_dot(unit="kg/s");/*mass flow rate*/
equation
p_0_SI=p_0*1.01*10^5;
m_dot=((p_0_SI*A_star)/sqrt(T_0))*sqrt((gama/R)*(2/(gama+1))^((gama+1)/(gama-1)));

/*The  answer may slightly vary due to  rounding off values*/
end Ex10_5;
