package Ex11_3
model Ex11_3_a
parameter Integer n=20;

parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

Real M_inf[n];/*Mach number*/

Real C_p_cr[n];/*critical pressure coefficient*/

parameter Real C_p0_min=-0.43;/*minimum pressure coefficient for incompressible flow*/
Real C_p_min[n];/*minimum pressure coefficient for compressible flow*/

Real M_cr_array[n];/*array of critical Mach number*/
Real M_cr;/*critical Mach number*/
algorithm

M_inf[1]:=0.1;

for i in 2:n loop
M_inf[i]:=M_inf[i-1]+0.04;
end for;

for i in 1:n loop
C_p_cr[i]:=(2/(gama*M_inf[i]^2))*(((1+(((gama-1)/2)*M_inf[i]^2))/(1+((gama-1)/2)))^(gama/(gama-1))-1);
C_p_min[i]:=C_p0_min/sqrt(1-M_inf[i]^2);

if(C_p_cr[i]>=(C_p_min[i]-0.1) and C_p_cr[i]<=(C_p_min[i] +0.1)) then
M_cr_array[i]:=M_inf[i];
else
M_cr_array[i]:=0;
end if;

M_cr:=max(M_cr_array);
end for;
end Ex11_3_a;

model Ex11_3_b
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
Real M_cr(start=0.001);/*critical Mach number*/
Real C_p_cr;/*critical pressure coefficient*/

parameter Real C_p0_min=-0.43;/*minimum pressure coefficient for incompressible flow*/
Real C_p_min;/*minimum pressure coefficient for compressible flow*/

equation
C_p_cr=(2/(gama*M_cr^2))*(((1+(((gama-1)/2)*M_cr^2))/(1+((gama-1)/2)))^(gama/(gama-1))-1);

C_p_min=C_p0_min/sqrt(1-M_cr^2);

C_p_cr=C_p_min;
end Ex11_3_b;
end Ex11_3;
