class Ex12_1
parameter Real alpha_deg(unit="deg")=5;/*angle of attack of the flat plate in degree*/
Real alpha_rad(unit="rad");/*angle of attack of the flat plate in radian*/
parameter Real M_inf=3;/*Mach number of the flow*/
Real c_l;/*lift coefficient of the flat plate*/
Real c_d;/*drag coefficient of the flat plate*/

equation

alpha_rad=Modelica.SIunits.Conversions.from_deg(alpha_deg);
c_l=(4*alpha_rad)/sqrt(M_inf^2-1);
c_d=(4*alpha_rad^2)/sqrt(M_inf^2-1);

/*The  answer may slightly vary due to  rounding off values*/
end Ex12_1;
