package Ex14_1
model Ex14_1_a
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real M_1=8;/*Mach number of the flow*/
 
parameter Real alpha_deg(unit="deg")=15;/*angle of attack of the plate in degree*/
Real alpha_rad(unit="deg");/*angle of attack of the plate in radian*/
Real theta_deg(unit="deg");/*deflection angle in degree for oblique shock*/
Real theta_rad(unit="rad");/*deflection angle in radian for oblique shock*/
parameter Real nu1(unit="deg")=95.62;/*value of the Prandtl-Meyer function ahead of expansion wave*/
Real nu2(unit="deg");/*value of the Prandtl-Meyer function behind the expansion wave*/

parameter Real M_2=14.32;/*Mach number of the flow behind of expansion wave*/
parameter Real p01_by_p1=0.9763*10^4;/*ratio of total pressure to static pressure ahead of expansion wave*/

parameter Real p02_by_p2=0.4808*10^6;/*ratio of total pressure to static pressure behind of expansion wave*/

Real p2_by_p1;/*ratio of static pressure ahead and behind of expansion wave*/ 
Real C_p2;/*pressure coefficient on the top surface of the plate*/

parameter Real beta_deg(unit="deg")=21;/*wave angle in degree for oblique shock*/
Real beta_rad(unit="rad");/*wave angle in radian for oblique shock*/

Real M_n1;/*normal component of Mach number ahead of oblique shock*/
parameter Real p3_by_p1=9.443;/*ratio of static pressure ahead and behind of oblique wave*/
Real C_p3;/*pressure coefficient on the bottom surface of the plate*/

Real c_n;/*normal force coefficient on the plate*/

Real c_l;/*lift coefficient of the flat plate*/
Real c_d;/*drag coefficient of the flat plate*/
Real L_D;/*lift to drag ratio of the plate*/

equation
alpha_rad=Modelica.SIunits.Conversions.from_deg(alpha_deg);
theta_deg=alpha_deg;
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
beta_rad=Modelica.SIunits.Conversions.from_deg(beta_deg);

nu2=nu1+theta_deg;

p2_by_p1=p01_by_p1/p02_by_p2;
C_p2=(2/(gama*M_1^2))*(p2_by_p1-1);

M_n1=M_1*sin(beta_rad);
C_p3=(2/(gama*M_1^2))*(p3_by_p1-1);

c_n=C_p3-C_p2;
c_l=c_n*cos(alpha_rad);
c_d=c_n*sin(alpha_rad);
L_D=c_l/c_d;
end Ex14_1_a;
model Ex14_1_b
parameter Real alpha_deg(unit="deg")=15;/*angle of attack of the plate in degree*/
Real alpha_rad(unit="rad");/*angle of attack of the plate in radian*/

parameter Real C_p2=0;/*pressure coefficient on the top surface of the plate*/

Real C_p3;/*pressure coefficient on the bottom surface of the plate*/

Real c_l;/*lift coefficient of the flat plate*/
Real c_d;/*drag coefficient of the flat plate*/
Real L_D;/*lift to drag ratio of the plate*/
equation
alpha_rad=Modelica.SIunits.Conversions.from_deg(alpha_deg);
C_p3=2*(sin(alpha_rad))^2;
c_l=(C_p3-C_p2)*cos(alpha_rad);
c_d=(C_p3-C_p2)*sin(alpha_rad);
L_D=c_l/c_d;
end Ex14_1_b;
end Ex14_1;
