class Ex16_2
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg.K")=287;/*Specific Gas Constant*/

parameter Real M_e=3;/*Mach number of upper plate*/
parameter Real T_w(unit="K")=288.3;/*temperature of lower the plate*/
parameter Real T_e(unit="K")=288.3;/*temperature of upper the plate*/
Real u_e(unit="m/s");/*velocity of the upper wall*/

parameter Real p_e(unit="N/m^2")=1.01*10^5;/*air pressure throughout the flow*/
Real rho_e(unit="kg/m^3");/*air density at both plates*/
parameter Real tau_w(unit="N/m^2")=72;/* the shear stress at the lower wall*/
Real c_f;/*skin friction coefficient*/

Real C_H;/*Stanton number*/

parameter Real Pr=0.71;/*Prandtl number*/
parameter Real c_p(unit="J.kg^(-1).K^(-1)")=1004.5;/*specific heat at constant pressure of air*/
Real h_aw(unit="J/kg");/*adiabatic wall enthalpy*/
Real h_w(unit="J/kg");/*wall enthalpy*/

Real q_dot_w(unit="W/m^2");/*heat transfer to either plate*/

equation
u_e=M_e*sqrt(gama*R*T_e);
rho_e=p_e/(R*T_e);
c_f=tau_w/((1/2)*rho_e*u_e^2);
C_H=c_f/(2*Pr);
h_aw=c_p*T_e+Pr*(u_e^2/2);
h_w=c_p*T_w;
q_dot_w=rho_e*u_e*(h_aw-h_w)*C_H;

/*The  answer may slightly vary due to  rounding off values*/
end Ex16_2;
