class Ex18_1
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg.K")=287;/*Specific Gas Constant*/

parameter Real c(unit="m")=2;/*chord length of the plate*/
parameter Real S(unit="m^2")=40;/*planform area of the plate*/
parameter Real T_inf(unit="K")=288;/*temperature of the flow*/
parameter Real p_inf(unit="N/m^2")=1.01*10^5;/*pressure of the flow*/
parameter Real mu_inf(unit="kg/m.s")=1.7894*10^(-5);/*air viscosity at standard sea level condition*/
Real rho_inf(unit="kg/m^3");/*air density of the flow*/
Real a_inf(unit="m/s");/*speed of sound through the flow*/

/*Number-a*/
parameter Real V_a(unit="m/s")=100;/*free stream velocity for case a*/
Real M_inf_a;/*Mach number for case a*/
Real Re_c_a;/*Reynolds number for case a*/
Real C_f_a;/*skin friction coefficient for case a*/
Real D_f_a(unit="N");/* friction drag on one surface of the plate for case a*/
Real D_a(unit="N");/*total friction drag for case a*/

/*Number-b*/
parameter Real V_b(unit="m/s")=1000;/*free stream velocity for case b*/
Real M_inf_b;/*Mach number for case b*/
Real Re_c_b;/*Reynolds number for case b*/
Real C_f_b;/*skin friction coefficient for case b*/
Real D_f_b(unit="N");/* friction drag on one surface of the plate for case b*/
Real D_b(unit="N");/*total friction drag for case b*/

equation
rho_inf=p_inf/(R*T_inf);
a_inf=sqrt(gama*R*T_inf);

/*Number-a*/
M_inf_a=V_a/a_inf;
Re_c_a=(rho_inf*V_a*c)/mu_inf;
C_f_a=1.328/sqrt(Re_c_a);
D_f_a=(1/2)*rho_inf*V_a^2*S*C_f_a;
D_a=2*D_f_a;

/*Number-b*/
M_inf_b=V_b/a_inf;
Re_c_b=(rho_inf*V_b*c)/mu_inf;
C_f_b=1.2/sqrt(Re_c_b);
D_f_b=(1/2)*rho_inf*V_b^2*S*C_f_b;
D_b=2*D_f_b;

/*The  answer may slightly vary due to  rounding off values*/
end Ex18_1;
