class Ex18_2
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg.K")=287;/*Specific Gas Constant*/

parameter Real c(unit="m")=2;/*chord length of the plate*/
parameter Real S(unit="m^2")=40;/*planform area of the plate*/
parameter Real M_e=2.94;/*Mach number of the flow*/
parameter Real Pr=0.71;/*Prandtl number*/
Real r;/*recovery factor*/

parameter Real T0_Te=2.74;/*temperature ratio*/
Real Taw_Te;/*temperature tario at adiabatic condition*/
parameter Real T_e(unit="K")=288;/*temperature of the flow*/
Real T_star(unit="K");/*reference temperature*/

parameter Real p_star(unit="N/m^2")=1.01*10^5;/*pressure of the flow*/
Real rho_star(unit="kg/m^3");/*reference density*/

parameter Real mu_0(unit="kg/m.s")=1.7894*10^(-5);/*air viscosity at sea level*/
Real mu_star(unit="kg/m.s");/*reference air viscosity*/

parameter Real u_e(unit="m/s")=1000;/*free stream velocity*/
Real Re_c_star;/*reference Reynolds number*/

Real C_f_star;/*reference skin friction coefficient*/

Real D_f(unit="N");/* friction drag on one side of the plate*/
Real D(unit="N");/*total friction drag*/
equation
r=sqrt(Pr);
Taw_Te=1+r*(T0_Te-1);

T_star/T_e=1+0.032*M_e^2+0.58*(Taw_Te-1);

rho_star=p_star/(R*T_star);

mu_star/mu_0=(T_star/T_e)^(3/2)*(T_e+110)/(T_star+110);

Re_c_star=(rho_star*u_e*c)/mu_star;

C_f_star=1.328/sqrt(Re_c_star);

D_f=(1/2)*rho_star*u_e^2*S*C_f_star;
D=2*D_f;
/*The  answer may slightly vary due to  rounding off values*/
end Ex18_2;
