class Ex2_1
parameter Real pi = Modelica.Constants.pi;

parameter Real l(unit="m")=1.0;/*wavelength of the wall*/
parameter Real h(unit="m")=0.01;/*amplitude of the wall*/
parameter Real V_infinite(unit="m/s")=240;/*freestream velocity*/
parameter Real M_infinite=0.7;/*freestream Mach number*/
Real beta;
Real dv_dt_v(unit="s^(-1)");/*time rate of change of the volume of the fluid element, per unit volume*/
equation
beta=sqrt(1-M_infinite^2);
dv_dt_v=(beta-(1/beta))*V_infinite*h*((2*pi)/l)^2*exp(-2*pi*beta);
/*The  answer may slightly vary due to  rounding off values*/
end Ex2_1;
