class Ex3_6
/*velocity conversion from mile per hour to meter per second- 1 mi/h=0.447 m/s */
/*pressure conversion from N/m^2 to atm- 1 atm=1.01*10^5 N/m^2;*/

/*Number-a*/
parameter Real V2_miph_a(unit="mi/h")=100;/*velocity of the flow at the test section in mi/h*/
Real V2_a(unit="m/s");/*velocity of the flow at the test section in m/s*/

parameter Real contract_ratio=10/1;/*contraction ratio of the nozzle*/
Real A2_A1;/*ratio of test section crossectional area and inlet crossectional area*/
parameter Real rho(unit="kg/m^3")=1.23;/*air density at sea level*/
parameter Real p2(unit="N/m^2")=1.01*10^5;/*pressure in the test section*/ 

Real p1_SI_a(unit="N/m^2");/*reservoir pressure in SI unit*/ 
Real p1_a(unit="atm");/*reservoir pressure in atmospheric unit*/

/*Number-b*/
parameter Real V2_miph_b(unit="mi/h")=200;/*velocity of the flow at the test section in mi/h*/
Real V2_b(unit="m/s");/*velocity of the flow at the test section in m/s*/

Real p1_SI_b(unit="N/m^2");/*reservoir pressure in SI unit*/ 
Real p1_b(unit="atm");/*reservoir pressure in atmospheric unit*/
equation
/*Number-a*/
V2_a=V2_miph_a*0.447;
A2_A1=1/contract_ratio;
p1_SI_a-p2=(1/2)*rho*V2_a^2*(1-A2_A1^2);
p1_a=p1_SI_a/(1.01*10^5);

/*Number-b*/
V2_b=V2_miph_b*0.447;
p1_SI_b-p2=(1/2)*rho*V2_b^2*(1-A2_A1^2);
p1_b=p1_SI_b/(1.01*10^5);
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_6;
