class Ex3_9
/*velocity conversion from mile per hour to meter per second- 1 mi/h=0.447 m/s */

parameter Real rho(unit="kg/m^3")=0.81935;/*free stream density at altitude 4 km*/
parameter Real p1(unit="N/m^2")=6.166*10^4;/*free stream pressure at altitude 4 km*/ 
parameter Real p0(unit="N/m^2")=6.7*10^4;/*total pressure from pitot tube*/
Real V1(unit="m/s");/*velocity of the airplane*/
Real V1_miph(unit="mi/h");/*velocity of the airplane in mile per hour*/
equation
V1=sqrt((2*(p0-p1))/rho);
V1_miph=V1/0.447;
end Ex3_9;
