class Ex4_1
parameter Real c(unit="m")=0.64;/*chord of the airfoil*/
Real S(unit="m^2");/*area of the per unit span of the wing*/
parameter Real rho_infinite(unit="kg/m^3")=1.23;/* atmospheric density at sea level*/
Real q_infinite(unit="N/m^2");/*dynamic pressure*/
Real c_l;/*lift coefficient*/
parameter Real V_infinte(unit="m/s")=70;/*free stream velocity*/
parameter Real L_das(unit="N/m")=1254;/*lift per unit span*/
Real alpha(unit="deg");/*angle of attack*/
parameter Real mu_infiite(unit="kg/(m.s)")=1.789*10^(-5);/*viscocity of the air*/
Real Re;/*Reynolds number*/
Real c_d;/*lift coefficient*/
Real D_das(unit="N/m");/*drag per unit span*/
equation
q_infinite=(1/2)*rho_infinite*V_infinte^2;
S=c*1;
c_l=L_das/(q_infinite*S);
alpha=4;
Re=(rho_infinite*V_infinte*c)/mu_infiite;
c_d=0.0068;
D_das=q_infinite*S*c_d;
end Ex4_1;
