class Ex4_10
parameter Real Re_xcr=1*10^6;/*crirical Reynolds number at tralling edge*/
parameter Real Re_c=3.1*10^6;/*Reynolds number at tralling edge*/

Real x1_by_c;/*location of the transition point relative to the chord length*/

Real Re_x1;/*Reynolds number at transition point */

Real C_f1_laminar;/*laminar skin-friction drag coefficient for single surface upto transition point*/
Real C_f1_turbulent;/*turbulent skin-friction drag coefficient for single surface upto transition point*/
Real C_fc_turbulent=0.00372;/*turbulent skin-friction drag coefficient for single surface upto trailing edge*/

Real C_f;/*skin-friction drag coefficient for single surface*/
Real C_f_net;/*total skin-friction drag coefficient for both surface*/
equation
x1_by_c=Re_xcr/Re_c;
Re_x1=x1_by_c*Re_c;
C_f1_laminar=1.328/sqrt(Re_x1);
C_f1_turbulent=0.074/(Re_x1)^(1/5);
C_f=x1_by_c*C_f1_laminar+C_fc_turbulent-x1_by_c*C_f1_turbulent;
C_f_net=2*C_f;
/*The  answer may slightly vary due to  rounding off values*/
end Ex4_10;
