class Ex4_2
parameter Real c(unit="m")=0.64;/*chord of the airfoil*/
Real S(unit="m^2");/*area of the per unit span of the wing*/
parameter Real rho_infinite(unit="kg/m^3")=1.23;/* atmospheric density at sea level*/
parameter Real V_infinte(unit="m/s")=70;/*free stream velocity*/
Real q_infinite(unit="N/m^2");/*dynamic pressure*/
Real c_mac=-0.05;/*moment coefficient*/
Real M_ac_das(unit="Nm");/*moment per unit span*/
equation
q_infinite=(1/2)*rho_infinite*V_infinte^2;
S=c*1;
M_ac_das=q_infinite*S*c*c_mac;
end Ex4_2;
