class Ex4_6
parameter Real alpha_0(unit="deg")=-1.1;/*zero lift angle of attack*/
parameter Real c_l_0=0;/*zero lift coefficient*/

parameter Real alpha_1(unit="deg")=4;/*angle of attack*/
parameter Real c_l_1=0.55;/*lift coefficient*/
parameter Real c_m_c4_1=-0.005;/*moment coefficient about the quarter cord point*/

parameter Real alpha_2(unit="deg")=-4;/*angle of attack*/
parameter Real c_m_c4_2=-0.0125;/*moment coefficient about the quarter cord point*/

Real a_0(unit="per deg");/*lift curve slope*/
Real m_0(unit="per deg");/*slope of the moment coefficient curve*/
Real x_ac_bar;/*location of the aerodynamic center as a fraction of the chord length*/
equation
a_0=(c_l_1-c_l_0)/(alpha_1-alpha_0);
m_0=(c_m_c4_1-c_m_c4_2)/(alpha_1-alpha_2);
x_ac_bar=-(m_0/a_0)+0.25;
end Ex4_6;
