class Ex5_3
/*Conversion from radian to degree 1 radian=180/pi degree*/
/*Conversion from degree to radian 1 degree=pi/180 radian*/
parameter Real pi = Modelica.Constants.pi;

parameter Real AR=7.96;/*aspect ratio of the wing*/
parameter Real tau=0.04;/*lift efficiency factor*/

parameter Real a_0_deg(unit="per deg")=0.1;/*lift curve slope of the airfoil in per degree*/
Real a_0(unit="per rad");/*lift curve slope of the airfoil in per radian*/
Real a(unit="per rad");/*lift curve slope of the wing in per radian*/
Real a_deg(unit="per deg");/*lift curve slope of the wing in per degree*/

parameter Real C_L=0.21;/*cruising lift coefficient of the aircraft*/
parameter Real alpha_0(unit="deg")=-2;/*zero lift angle of attack*/
Real alpha(unit="deg");/* cruising angle of attack*/

equation
a_0=a_0_deg/(pi/180);
a=a_0/(1+((a_0*(1+tau))/(pi*AR)));
a_deg=a/(180/pi);

C_L=a_deg*(alpha-alpha_0);
end Ex5_3;
