class Ex5_4
/*Conversion from radian to degree 1 radian=180/pi degree*/
/*Conversion from degree to radian 1 degree=pi/180 radian*/
parameter Real pi = Modelica.Constants.pi;

parameter Real alpha_L_0(unit="deg")=-1;/*zero lift angle of angle of attack of the airfoil*/
parameter Real c_l_0=0;/*lift coefficient at alpha_L_0 */
parameter Real alpha_1(unit="deg")=7;/* angle of attack*/
parameter Real c_l_1=0.9;/*lift coefficient at alpha_1 */

Real a_0_deg(unit="per deg");/*lift curve slope for airfoil in degree*/
Real a_0_rad(unit="per rad");/*lift curve slope for airfoil in radian*/

parameter Real AR=7.61;/*aspect ratio of the wing*/
parameter Real delta=0.01;/*induced drag factor*/
Real tau;
Real e;/*span efficiency factor*/

Real a_rad(unit="rad^(-1)");/*lift curve slope for wing in radian*/
Real a_deg(unit="deg^(-1)");/*lift curve slope for wing in degree unit*/

parameter Real alpha(unit="deg")=4;/*angle of attack*/
Real C_L;/*lift coefficient at 4 deg angle of attack in wing*/

Real alpha_i_rad(unit="rad");/*induced angle of attack in radian*/
Real alpha_i_deg(unit="deg");/*induced angle of attack in degree*/

Real alpha_eff(unit="deg");/*effective angle of attack in degree*/
Real c_l;/*lift coefficient sensed by the airfoil*/
Real c_d;/*drag coefficient sensed by the airfoil*/

Real C_D;/*drag coefficient for the wing*/

equation
a_0_deg=(c_l_1-c_l_0)/(alpha_1-alpha_L_0);
a_0_rad=a_0_deg/(pi/180);

tau=delta;
e=1/(1+delta);

a_rad=a_0_rad/(1+((a_0_rad*(1+tau))/(pi*AR)));
a_deg=a_rad/(180/pi);

C_L=a_deg*(alpha-alpha_L_0);

alpha_i_rad=C_L/(pi*AR);
alpha_i_deg=alpha_i_rad*(180/pi);
alpha_eff=alpha-alpha_i_deg;

c_l=a_0_deg*(alpha_eff-alpha_L_0);
c_d=0.0065;

C_D=c_d+C_L^2/(pi*e*AR);

/*The  answer may slightly vary due to  rounding off values*/
end Ex5_4;
